/*
 *
 *  ALL03
 *
 *  26.07.2002
 *
 *  by Fabio Sturman
 *
 *  fabio.sturman@tiscali.it
 *
 *  90slv.h
 *
 *  main module include file
 *
 */

/* Copyright (c) 2002 Fabio Sturman (fabio.sturman@tiscali.it)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

/*- AT90SLV Level 1 --------------------------------------*/

#define DEBUG 1

#define PIN_MISO_2323    22
#define PIN_NRESET_2323  17
#define PIN_SCK_2323     23
#define PIN_MOSI_2323    21
#define PIN_VCC_2323     27
#define PIN_CLOCK_2323   18

#define set_sdi(x)      all03_wr_pin(pin_sdi,x)
#define set_sdo(x)      all03_wr_pin(pin_sdo,x)
#define get_sdo()       all03_rd_pin(pin_sdo)
#define set_sii(x)      all03_wr_pin(pin_sii,x)
#define set_sci(x)      all03_wr_pin(pin_sci,x)
#define set_power()     all03_wr_vcc_pin(pin_vcc,1)

/*- ATtiny85 Level 2 --------------------------------------*/

#define print_chip_model() printf("Model: %s\n",chip_model)
#define PROC_STRING "\nINSERT %s and press <Enter>\n",chip_model

#define IS_ATTINY85     !strcmp(chip_model,"ATtiny85")

 /*- ATtiny85 Level 1 --------------------------------------*/

/* write read */
unsigned char wr_rd_serial(unsigned char sdi, unsigned char sii);
/* put chip in programming mode */
int chip_init(void);
int cmd_programming_enable(void);
void cmd_chip_erase(void);
unsigned char cmd_read_program_memory(int lohi, unsigned short int address);
void cmd_write_program_memory(int lohi, unsigned short int address, unsigned char data);
unsigned char cmd_read_eeprom_memory(unsigned short int address);
void cmd_write_eeprom_memory(unsigned short int address, unsigned char data);
unsigned char cmd_read_lock_and_fuse_bits(unsigned char sdi1, unsigned char sii1, unsigned char sdi2, unsigned char sii2, unsigned char sdi3, unsigned char sii3);
void cmd_write_lock_bits(int lock_bit_1, int lock_bit_2);
void cmd_write_fstrt_bit(int nfstrt);
unsigned char cmd_read_signature_bytes(unsigned short int address);

/*- ATtiny85 Level 2 --------------------------------------*/

void edit_chip_model(void);
void display_lock_and_fuse_bits(void);
void read_lock_and_fuse_bits(void);
void write_default_fuse_bits(void);
void chip_erase(void);
void read_signature_bytes(void);
void display_help(void);
int main(int argc, char *argv[]);

